rm(list=ls()) # clears the R workspace
# we built up the patterned frequencies of Table 1 
# in an R matrix object the first two columns are the
# patterns, the third column lists the frequencies
x1<-c(1,1,100) # first pattern and frequency
x2<-c(1,2,50) # second pattern and frequency
x3<-c(2,1,90) # third pattern and frequency
x4<-c(2,2,190) # fourth pattern and frequency
# the four (row) vectors are combined to a matrix
table1<-rbind(x1,x2,x3,x4)
table1
library(confreq) # loads the R package 'confreq'
# brings the data matrix into a
# pattern matrix which can be analyzed
table1_new <- dat2fre(fre2dat(table1))
table1_new
#finally the CFA command for the main effects model
res_2<-CFA(patternfreq = table1_new,form = "~ A + B")
# This will assign the results from applying
# the function CFA() to the data in 'res_2' 
summary(res_2, sorton = 'pat.', showall = TRUE, 
        type = 'pChi')
# The command summary gives a nice summary 
# output of the results sorted by 'pat.'
# Types and antitypes based on 'pChi'
